/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.WorkbenchBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WorkbenchBlockEntity
extends ElectricityModuleLootBlockEntity
implements IWorkbench {
    public static final int DATA_POWERED = 0;
    @Nullable
    protected Player currentUser;
    protected int updateTimer;
    protected int countsHash;
    protected final DataSlot selectedRecipe = DataSlot.m_39401_();
    protected final DataSlot searchNeighbours = DataSlot.m_39401_();
    protected final ContainerData data = new BuildableContainerData(builder -> builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {}));

    public WorkbenchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.WORKBENCH.get(), pos, state);
    }

    public WorkbenchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 12);
        this.selectedRecipe.m_6422_(-1);
        this.searchNeighbours.m_6422_(1);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return menu instanceof WorkbenchMenu;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "workbench", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new WorkbenchMenu(windowId, playerInventory, this, this.data);
    }

    public void writeMenuData(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.selectedRecipe.m_6501_());
        buffer.m_130130_(this.searchNeighbours.m_6501_());
        buffer.m_130130_(this.isNodePowered() ? 1 : 0);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)WorkbenchBlock.POWERED)) {
            return (Boolean)state.m_61143_((Property)WorkbenchBlock.POWERED);
        }
        return false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)WorkbenchBlock.POWERED)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)WorkbenchBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void m_5856_(Player player) {
        super.m_5856_(player);
        this.setUser(player);
    }

    @Override
    public void m_5785_(Player player) {
        super.m_5785_(player);
        this.setUser(null);
    }

    public boolean isOccupied() {
        return this.getUser() != null;
    }

    @Nullable
    public Player getUser() {
        WorkbenchMenu menu;
        AbstractContainerMenu abstractContainerMenu;
        if (this.currentUser != null && this.currentUser.m_6084_() && (abstractContainerMenu = this.currentUser.f_36096_) instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).getContainer() == this) {
            return this.currentUser;
        }
        return null;
    }

    public void setUser(@Nullable Player player) {
        if (!this.isOccupied() || player == null) {
            this.currentUser = player;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WorkbenchBlockEntity workbench) {
        workbench.sendCountsToUser(false);
    }

    public void sendCountsToUser(boolean force) {
        Player player = this.getUser();
        if (player != null && (this.updateTimer++ % 4 == 0 || force)) {
            Map<Item, Integer> newCounts = Utils.countItems(true, this.getSupplyContainers());
            int hash = newCounts.hashCode();
            if (hash == this.countsHash && !force) {
                return;
            }
            this.countsHash = hash;
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            for (Map.Entry<Item, Integer> entry : newCounts.entrySet()) {
                map.put(Item.m_41393_((Item)entry.getKey()), entry.getValue());
            }
            ((WorkbenchMenu)player.f_36096_).updateItemCounts((Map<Integer, Integer>)map);
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageWorkbench.ItemCounts((Map<Integer, Integer>)map));
        }
    }

    @Override
    public void performCraft(WorkbenchContructingRecipe recipe) {
        Map<Item, Integer> items = this.getConsumedMaterialItems(recipe);
        if (items != null) {
            this.removeItems(items);
        }
    }

    @Override
    public boolean canCraft(WorkbenchContructingRecipe recipe) {
        return this.isNodePowered() && this.getConsumedMaterialItems(recipe) != null;
    }

    @Override
    public DataSlot selectedRecipeDataSlot() {
        return this.selectedRecipe;
    }

    @Override
    public DataSlot searchNeighboursDataSlot() {
        return this.searchNeighbours;
    }

    @Override
    public Container getWorkbenchContainer() {
        return this;
    }

    @Override
    public ContainerLevelAccess createLevelAccess() {
        return ContainerLevelAccess.m_39289_((Level)Objects.requireNonNull(this.f_58857_), (BlockPos)this.f_58858_);
    }

    protected boolean shouldSearchNeighbours() {
        return this.searchNeighbours.m_6501_() != 0;
    }

    @Nullable
    private Map<Item, Integer> getConsumedMaterialItems(WorkbenchContructingRecipe recipe) {
        Map<Item, Integer> counts = Utils.countItems(true, this.getSupplyContainers());
        HashMap<Item, Integer> materials = new HashMap<Item, Integer>();
        for (StackedIngredient material : recipe.getMaterials()) {
            int remaining = material.count();
            for (ItemStack stack : material.ingredient().m_43908_()) {
                Item item = stack.m_41720_();
                int count = counts.getOrDefault(item, 0);
                if ((count -= materials.getOrDefault(item, 0).intValue()) <= 0) continue;
                if (count >= remaining) {
                    materials.merge(item, remaining, Integer::sum);
                    remaining = 0;
                    break;
                }
                materials.merge(item, count, Integer::sum);
                remaining -= count;
            }
            if (remaining <= 0) continue;
            return null;
        }
        return materials;
    }

    private boolean removeItems(Map<Item, Integer> items) {
        ArrayList transactions = new ArrayList();
        for (Pair<Direction, Container> pair2 : this.getSupplyContainers()) {
            Direction direction = (Direction)pair2.first();
            Container container = (Container)pair2.second();
            Utils.getContainerSlots(container, direction).forEach(slot -> {
                ItemStack stack = container.m_8020_(slot);
                if (stack.m_41619_() || stack.m_41768_()) {
                    return;
                }
                if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
                    return;
                }
                Item item = stack.m_41720_();
                Integer count = (Integer)items.get(item);
                if (count != null) {
                    if (stack.m_41613_() < count) {
                        count = count - stack.m_41613_();
                        items.put(item, count);
                        transactions.add(Pair.of((Object)container, () -> stack.m_41764_(0)));
                    } else {
                        Integer finalCount = count;
                        transactions.add(Pair.of((Object)container, () -> stack.m_41774_(finalCount.intValue())));
                        items.remove(item);
                    }
                }
            });
        }
        if (items.isEmpty()) {
            transactions.forEach(pair -> {
                ((Runnable)pair.right()).run();
                ((Container)pair.left()).m_6596_();
            });
            return true;
        }
        return false;
    }

    private List<Pair<Direction, Container>> getSupplyContainers() {
        ArrayList<Pair<Direction, Container>> list = new ArrayList<Pair<Direction, Container>>();
        list.add(Pair.of(null, (Object)this));
        if (this.shouldSearchNeighbours()) {
            Direction direction = this.getDirection();
            this.getContainer(direction).ifPresent(list::add);
            this.getContainer(direction.m_122424_()).ifPresent(list::add);
            this.getContainer(direction.m_122428_()).ifPresent(list::add);
            this.getContainer(direction.m_122427_()).ifPresent(list::add);
        }
        Optional.ofNullable(this.getUser()).ifPresent(player -> list.add(Pair.of(null, (Object)player.m_150109_())));
        return list;
    }

    private Optional<Pair<Direction, Container>> getContainer(Direction offset) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(pos = this.f_58858_.m_121945_(offset))) instanceof Container) {
            Container container = (Container)blockEntity;
            BlockState state = this.f_58857_.m_8055_(pos);
            Block block = state.m_60734_();
            if (container instanceof ChestBlockEntity && block instanceof ChestBlock) {
                container = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)this.f_58857_, (BlockPos)pos, (boolean)true);
            }
            if (container != null) {
                return Optional.of(Pair.of((Object)offset.m_122424_(), (Object)container));
            }
        }
        return Optional.empty();
    }

    private Direction getDirection() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return Direction.NORTH;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("SelectedRecipe", 3)) {
            this.selectedRecipe.m_6422_(tag.m_128451_("SelectedRecipe"));
        }
        if (tag.m_128425_("IncludeNeighbours", 1)) {
            this.searchNeighbours.m_6422_(tag.m_128471_("IncludeNeighbours") ? 1 : 0);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SelectedRecipe", this.selectedRecipe.m_6501_());
        tag.m_128379_("IncludeNeighbours", this.searchNeighbours.m_6501_() != 0);
    }
}

